ORCA/M Asm65816 2.1.0

0001 A8B3
0002 A8B3                       TITLE ', FUNCTIONS.a - LoaderInit'
0003 A8B3              *
0004 A8B3              ****************************************************************
0005 A8B3              *
0006 A8B3              *              Initialization ($01)
0007 A8B3              *
0008 A8B3              *  Inputs:     none
0009 A8B3              *
0010 A8B3              *  Outputs:    none
0011 A8B3              *
0012 A8B3              ****************************************************************
0013 A8B3              *
0014 A8B3              LoaderInit PROC Export
0015 A8B3                       LoadSegCheck 
0016 A8B3
0017 A8B3                       with Globals
0018 A8B3                       IMPORT draw_express,startup
0019 A8B3
0020 A8B3 8B                    phb                            ;set up DBR
0021 A8B4 4B                    phk   
0022 A8B5 AB                    plb   
0023 A8B6
0024 A8B6 AD 8C A6              lda   boot_flag                ;is this the initial system boot-up?
0025 A8B9 F0 0A                 beq   @restart                 ;no, must be a restart after using P8
0026 A8BB
0027 A8BB 0B                    phd   
0028 A8BC 20 94 B9              jsr   startup                  ;init my self
0029 A8BF B0 07                 bcs   @error                   ;oops!
0030 A8C1
0031 A8C1 2B                    pld                            ;restore the direct page
0032 A8C2 9C 8C A6              stz   boot_flag                ;fix the flag
0033 A8C5
0034 A8C5              @restart  
0035 A8C5 AB                    plb                            ;restore DBR
0036 A8C6 80 0F                 bra   NoError
0037 A8C8
0038 A8C8              @error    
0039 A8C8 2B                    pld                            ;restore caller's DP
0040 A8C9 AB                    plb                            ;and DBR
0041 A8CA 6B                    rtl                            ;and return to caller
0042 A8CB
0043 A8CB                       TITLE ', FUNCTIONS.a - Version, Status, Startup, Shutdown, Reset'
0044 A8CB              *
0045 A8CB              ****************************************************************
0046 A8CB              *
0047 A8CB              *              Loader Version ($04)
0048 A8CB              *
0049 A8CB              *  Inputs:     none
0050 A8CB              *
0051 A8CB              *  Outputs:    Loader Version (2 bytes)
0052 A8CB              *
0053 A8CB              ****************************************************************
0054 A8CB              *
0055 A8CB                       Export LoaderVersion
0056 A8CB A9 02 04     LoaderVersion lda   #Loader_Version
0057 A8CE 80 03                 bra   store_ret_value
0058 A8D0
0059 A8D0              *
0060 A8D0              ****************************************************************
0061 A8D0              *
0062 A8D0              *              Loader Status ($06)
0063 A8D0              *
0064 A8D0              *  Inputs:     none
0065 A8D0              *
0066 A8D0              *  Outputs:    Status (TRUE or FALSE 2 bytes)
0067 A8D0              *
0068 A8D0              ****************************************************************
0069 A8D0              *
0070 A8D0                       Export LoaderStatus
0071 A8D0              LoaderStatus  
0072 A8D0 A9 01 00              lda   #1                       ;status is ALWAYS started
0073 A8D3              store_ret_value  
0074 A8D3 83 07                 sta   7,s
0075 A8D5 80 00                 bra   NoError
0076 A8D7
0077 A8D7              *
0078 A8D7              ****************************************************************
0079 A8D7              *
0080 A8D7              *              Loader Startup  ($02)
0081 A8D7              *              Loader Shutdown ($03)
0082 A8D7              *              Loader Reset    ($05)
0083 A8D7              *              other non-implemented functions
0084 A8D7              *
0085 A8D7              *  Inputs:     none
0086 A8D7              *
0087 A8D7              *  Outputs:    none
0088 A8D7              *
0089 A8D7              ****************************************************************
0090 A8D7              *
0091 A8D7                       EXPORT LoaderReset
0092 A8D7              LoaderReset  
0093 A8D7                       EXPORT LoaderStartup
0094 A8D7              LoaderStartup  
0095 A8D7                       EXPORT LoaderShutdown
0096 A8D7              LoaderShutdown  
0097 A8D7
0098 A8D7 A9 00 00     NoError  lda   #0
0099 A8DA 18                    clc   
0100 A8DB 6B                    rtl   
0101 A8DC
0102 A8DC                       ENDP 
0103 A8DC
0104 A8DC                       TITLE ', FUNCTIONS.a - No Function'
0105 A8DC              *
0106 A8DC              ****************************************************************
0107 A8DC              *
0108 A8DC              *               Loader Unsupported Function
0109 A8DC              *
0110 A8DC              *  Inputs:     none
0111 A8DC              *
0112 A8DC              *  Outputs:    none
0113 A8DC              *
0114 A8DC              ****************************************************************
0115 A8DC              *
0116 A8DC              Load_NI  Proc Export
0117 A8DC                       LoadSegCheck 
0118 A8DC
0119 A8DC A9 02 00              lda   #$0002                   ;synthesize tool setup error
0120 A8DF 38                    sec   
0121 A8E0 6B                    rtl   
0122 A8E1
0123 A8E1                       EndP 
0124 A8E1
0125 A8E1                       TITLE ', FUNCTIONS.a - LoadNum'
0126 A8E1              *
0127 A8E1              ****************************************************************
0128 A8E1              *
0129 A8E1              *              Load Segment by Number ($0B)
0130 A8E1              *
0131 A8E1              *  Inputs:     UserID (2 bytes)
0132 A8E1              *              Load File Number (2 bytes)
0133 A8E1              *              Load Segment Number (2 bytes)
0134 A8E1              *  Outputs:    Address of segment (4 bytes)
0135 A8E1              *  Errors:     $0000 - Operation successful
0136 A8E1              *              $1101 - Segment not found
0137 A8E1              *              $1102 - OMF Version error
0138 A8E1              *              $1104 - File not Load File
0139 A8E1              *              $1107 - File Version error
0140 A8E1              *              $1109 - SegNum out of sequence
0141 A8E1              *              $00xx - GS/OS I/O error
0142 A8E1              *              $02xx - Memory Manager error
0143 A8E1              *
0144 A8E1              ****************************************************************
0145 A8E1              *
0146 A8E1              LoadNum  PROC EXPORT
0147 A8E1                       LoadSegCheck 
0148 A8E1
0149 A8E1                       with DirectPage, Globals
0150 A8E1                       Import find_user_id,merge_path,make_HET_ptr,seg_num_lookup
0151 A8E1                       Import setup_seg_ptrs,open_load_file,load_segment
0152 A8E1                       Import Process_Reloc,lock_segment,setup_base_ptr
0153 A8E1
0154 A8E1 A2 06 00              ldx   #func_0B_param_cnt       ;6 bytes of input
0155 A8E4 20 C6 B9              jsr   get_parameters           ;get the parameters
0156 A8E7
0157 A8E7              ISegNum  EQU   input_parms
0158 A8E7              IFileNum EQU   ISegNum+2
0159 A8E7              IUserID  EQU   IFileNum+2
0160 A8E7              OAddress EQU   1                        ;offset within stack
0161 A8E7
0162 A8E7 A5 E2                 lda   IFileNum                 ;see if this is file number one
0163 A8E9 3A                    dec   a
0164 A8EA D0 69                 bne   old_loader               ;sorry we will let the system loader handle it
0165 A8EC
0166 A8EC A5 E4                 lda   IUserID                  ;lets see if we know about this user ID
0167 A8EE 20 67 D4              jsr   find_user_id             ;If found temp_ptr setup
0168 A8F1 B0 62                 bcs   old_loader               ;not my job
0169 A8F3              ;
0170 A8F3              ;At this point all errors that we encounter must be returned to the caller since the file is mine.
0171 A8F3              ;
0172 A8F3 A0 02 00              ldy   #ID_Table_Entry.ExpressHandle
0173 A8F6 B7 62                 lda   [temp_ptr],y             ;get the ExpressLoad handle
0174 A8F8 AA                    tax   
0175 A8F9 C8                    iny   
0176 A8FA C8                    iny   
0177 A8FB B7 62                 lda   [temp_ptr],y
0178 A8FD A8                    tay   
0179 A8FE D0 09                 bne   @have_handle
0180 A900 8A                    txa   
0181 A901 D0 06                 bne   @have_handle             ;we have the handle
0182 A903 A9 F2 11              lda   #ExpressSegLost
0183 A906 38                    sec   
0184 A907 80 48                 bra   @error_exit              ;report error to the caller.
0185 A909              @have_handle  
0186 A909 20 46 D3              jsr   merge_path               ;we now have the expanded ExpressLoad pathname
0187 A90C
0188 A90C                                                      ;the segment we will have to load
0189 A90C 20 44 D2              jsr   make_HET_ptr
0190 A90F A5 E0                 lda   ISegNum
0191 A911 20 C8 D1              jsr   seg_num_lookup           ;convert the segment number to correct number
0192 A914 B0 3B                 bcs   @error_exit              ;the number is not valid
0193 A916 85 AC                 sta   search_seg               ;save the real segment to load.
0194 A918 20 5E D2              jsr   setup_seg_ptrs           ;setup pointers for the load
0195 A91B
0196 A91B A0 02 00              ldy   #HET_Entry.SegFlags      ;see if the segment is already loaded
0197 A91E B7 42                 lda   [HET_entry_ptr],y
0198 A920 30 13                 bmi   @already_in              ;this segment is already loaded
0199 A922              @do_load  
0200 A922 20 69 DD              jsr   open_load_file           ;open the puppy
0201 A925 B0 2A                 bcs   @error_exit              ;report error to the caller.
0202 A927 20 75 E1              jsr   load_segment             ;load the segment into memory
0203 A92A B0 25                 bcs   @error_exit              ;report error to the caller.
0204 A92C A5 AC                 lda   search_seg               ;relocate the segment
0205 A92E 20 05 D6              jsr   Process_Reloc
0206 A931 B0 1E                 bcs   @error_exit              ;report error to the caller.
0207 A933 80 0D                 bra   @continue1
0208 A935              @already_in  
0209 A935 4A                    lsr   a                        ;see if the segment is purgable?
0210 A936 90 07                 bcc   @continue
0211 A938 A5 AC                 lda   search_seg               ;go and lock the handle please
0212 A93A 20 06 E1              jsr   lock_segment
0213 A93D B0 E3                 bcs   @do_load
0214 A93F              @continue  
0215 A93F 20 80 D2              jsr   setup_base_ptr           ;please setup the base pointer
0216 A942              @continue1  
0217 A942 A5 9E                 lda   segment_entry+2          ;address of the segment
0218 A944 83 03                 sta   OAddress+2,s
0219 A946 A5 9C                 lda   segment_entry
0220 A948 83 01                 sta   OAddress,s
0221 A94A
0222 A94A A9 00 00              lda   #$0000
0223 A94D 18                    clc   
0224 A94E              @outta_here  
0225 A94E 4C 1B BA              jmp   return_to_caller         ;we were successful!!
0226 A951
0227 A951              @error_exit  
0228 A951 A6 E4                 ldx   IUserID
0229 A953 D0 F9                 bne   @outta_here              ;if user_id = 0, try old method
0230 A955
0231 A955              old_loader  
0232 A955                                                      ; space for output address is already on stack
0233 A955              ;        pha                            ;output Address
0234 A955              ;        pha
0235 A955 A5 E4                 lda   IUserID                  ;input UserID
0236 A957 D0 03                 bne   cont                     ;if 0, use global USERID
0237 A959 AD B6 A6              lda   |USERID
0238 A95C 48           cont     pha                            ;UserID
0239 A95D D4 E2                 pei   IFileNum                 ;File Number
0240 A95F D4 E0                 pei   ISegNum                  ;Segment Number
0241 A961 20 2A E6              jsr   Load_Segment             ;Load Segment routine
0242 A964              ; OAddress is already on stack, so we just have to return
0243 A964 4C 1B BA              jmp   return_to_caller
0244 A967                       ENDP 
0245 A967
0246 A967                       TITLE ', FUNCTIONS.a - ULoadNum'
0247 A967              *
0248 A967              ****************************************************************
0249 A967              *
0250 A967              *              UnLoad Segment by Number ($0C)
0251 A967              *
0252 A967              *  Inputs:     UserID (2 bytes)
0253 A967              *              Load File Number (2 bytes)
0254 A967              *              Load Segment Number (2 bytes)
0255 A967              *  Outputs:    none
0256 A967              *  Errors:     $0000 - Operation successful
0257 A967              *              $1101 - Segment not found
0258 A967              *              $00xx - GS/OS I/O error
0259 A967              *              $02xx - Memory Manager error
0260 A967              *
0261 A967              ****************************************************************
0262 A967              *
0263 A967              ULoadNum PROC EXPORT
0264 A967                       LoadSegCheck 
0265 A967
0266 A967                       with DirectPage, Globals
0267 A967                       Import make_HET_ptr,seg_num_lookup,make_purgable, \
0268 A967                       purge_all_dyn,find_user_id 
0269 A967
0270 A967 A2 06 00              ldx   #func_0C_param_cnt       ;get the number of parameters of the stack
0271 A96A 20 C6 B9              jsr   get_parameters
0272 A96D
0273 A96D              ISegNum  EQU   input_parms
0274 A96D              IFileNum EQU   ISegNum+2
0275 A96D              IUserID  EQU   IFileNum+2
0276 A96D
0277 A96D A5 E2                 lda   IFileNum                 ;see if this is file number one
0278 A96F D0 04                 bne   @check_for_1             ;we handle 0 and 1
0279 A971 85 E0                 sta   ISegNum
0280 A973 80 03                 bra   @skip_abort
0281 A975              @check_for_1  
0282 A975 3A                    dec   a
0283 A976 D0 3D                 bne   old_loader               ;sorry we will let the system loader handle it
0284 A978              @skip_abort  
0285 A978 A5 E4                 lda   IUserID                  ;see if this is for me
0286 A97A 20 67 D4              jsr   find_user_id
0287 A97D B0 36                 bcs   old_loader               ;must be the real system loaders
0288 A97F              ;
0289 A97F              ;At this point all errors that we encounter must be returned to the caller since the file is mine.
0290 A97F              ;
0291 A97F A0 02 00              ldy   #ID_Table_Entry.ExpressHandle
0292 A982 B7 62                 lda   [temp_ptr],y             ;get the ExpressLoad handle
0293 A984 AA                    tax   
0294 A985 C8                    iny   
0295 A986 C8                    iny   
0296 A987 B7 62                 lda   [temp_ptr],y
0297 A989 A8                    tay   
0298 A98A D0 09                 bne   @have_handle
0299 A98C 8A                    txa   
0300 A98D D0 06                 bne   @have_handle             ;we have the handle
0301 A98F A9 F2 11              lda   #ExpressSegLost
0302 A992 38                    sec   
0303 A993 80 1C                 bra   @error_exit              ;report error to the caller.
0304 A995              @have_handle  
0305 A995 86 88                 stx   ExpressHandle
0306 A997 84 8A                 sty   ExpressHandle+2
0307 A999
0308 A999 20 44 D2              jsr   make_HET_ptr
0309 A99C A5 E0                 lda   ISegNum
0310 A99E F0 0B                 beq   @do_all_dyn              ;we need to purge all dynamics
0311 A9A0 20 C8 D1              jsr   seg_num_lookup           ;convert the segment number to correct number
0312 A9A3 B0 0C                 bcs   @error_exit              ;the number is not valid
0313 A9A5 20 A5 DF              jsr   make_purgable
0314 A9A8 4C 1B BA              jmp   return_to_caller         ;return to the caller
0315 A9AB              @do_all_dyn  
0316 A9AB 20 F3 DF              jsr   purge_all_dyn
0317 A9AE              @outta_here  
0318 A9AE 4C 1B BA              jmp   return_to_caller         ;return the info please
0319 A9B1              @error_exit  
0320 A9B1 A6 E4                 ldx   IUserID
0321 A9B3 D0 F9                 bne   @outta_here
0322 A9B5              old_loader  
0323 A9B5 A5 E4                 lda   IUserID                  ;input UserID
0324 A9B7 D0 05                 bne   cont1                    ;if 0, use global USERID
0325 A9B9 AD B6 A6              lda   |USERID
0326 A9BC 85 E4                 sta   IUserID
0327 A9BE 48           cont1    pha                            ;UserID
0328 A9BF D4 E2                 pei   IFileNum                 ;File Number
0329 A9C1 D4 E0                 pei   ISegNum                  ;Segment Number
0330 A9C3              ;
0331 A9C3              ;        if any of the inputs are 0, unload dynamic segments only
0332 A9C3              ;
0333 A9C3 A9 01 00              lda   #1
0334 A9C6 A4 E2                 ldy   IFileNum
0335 A9C8 F0 05                 beq   cont2
0336 A9CA A4 E0                 ldy   ISegNum
0337 A9CC F0 01                 beq   cont2
0338 A9CE 3A                    dec   a
0339 A9CF 48           cont2    pha                            ;Dynamic Only Flag
0340 A9D0 F4 03 00              pea   $0003                    ;Purge Level
0341 A9D3 20 E6 EA              jsr   Purge_Segment
0342 A9D6 4C 1B BA              jmp   return_to_caller         ;return the info please
0343 A9D9
0344 A9D9                       ENDP 
0345 A9D9
0346 A9D9                       TITLE ', FUNCTIONS.a - LoadName'
0347 A9D9              *
0348 A9D9              ****************************************************************
0349 A9D9              *
0350 A9D9              *              Load Segment by Name ($0D)
0351 A9D9              *
0352 A9D9              *Stack before call:
0353 A9D9              *
0354 A9D9              *               previous contents
0355 A9D9              *               result space            word
0356 A9D9              *               result space            word
0357 A9D9              *               result space            word
0358 A9D9              *               result space            long
0359 A9D9              *               User ID                 word
0360 A9D9              *               Addr of load file name  long
0361 A9D9              *               Addr of load seg name   long
0362 A9D9              *       SP ---->
0363 A9D9              *
0364 A9D9              *Stack after call:
0365 A9D9              *
0366 A9D9              *               previous contents
0367 A9D9              *               load-segment number     word
0368 A9D9              *               load-file number        word
0369 A9D9              *               User ID                 word
0370 A9D9              *               Addr of the segment     long
0371 A9D9              *       SP ---->
0372 A9D9              *
0373 A9D9              *  Errors:     $0000 - Operation successful
0374 A9D9              *              $1101 - Segment not found
0375 A9D9              *              $1102 - OMF Version error
0376 A9D9              *              $1104 - File not Load File
0377 A9D9              *              $1107 - File Version error
0378 A9D9              *              $1108 - UserID error
0379 A9D9              *              $1109 - SegNum out of sequence
0380 A9D9              *              $00xx - GS/OS I/O error
0381 A9D9              *              $02xx - Memory Manager error
0382 A9D9              *
0383 A9D9              * How it works:
0384 A9D9              *       IF find_user_id(input_id) THEN                          {If found, ExpressHandle setup}
0385 A9D9              *         BEGIN
0386 A9D9              *           IF compare_path(input_path,ExpressLoad_path) THEN   {See if looking for loaded segment}
0387 A9D9              *             BEGIN
0388 A9D9              *               IF find_seg(input_seg_name) THEN                {See if segment is available}
0389 A9D9              *                 BEGIN
0390 A9D9              *                   IF seg_loaded(seg_num) THEN                 {See if the segment is loaded}
0391 A9D9              *                     BEGIN
0392 A9D9              *                       Return_parameters
0393 A9D9              *                       Exit ()                                 {return to the caller}
0394 A9D9              *                     END
0395 A9D9              *                   ELSE
0396 A9D9              *                     BEGIN
0397 A9D9              *                       Load_Seg(Seg_num)                       {load in the segment please}
0398 A9D9              *                       return_parameters
0399 A9D9              *                       Exit()                                  {return to the caller}
0400 A9D9              *                     END
0401 A9D9              *                 END
0402 A9D9              *               ELSE
0403 A9D9              *                 BEGIN                                         {segment not found}
0404 A9D9              *                   Return_error(Seg_Not_Found)
0405 A9D9              *                   Exit ()
0406 A9D9              *                 END
0407 A9D9              *           ELSE                                                {not same file}
0408 A9D9              *             BEGIN                                             {Pain in the Butt}
0409 A9D9              *               open_file(input_path)                           {open file, type check etc.}
0410 A9D9              *               get_express_seg                                 {get the ExpressLoad segment}
0411 A9D9              *               IF find_seg(input_seg_name) THEN                {See if segment is available}
0412 A9D9              *                 BEGIN
0413 A9D9              *                   IF seg_loaded(seg_num) THEN                 {See if the segment is loaded}
0414 A9D9              *                     BEGIN
0415 A9D9              *                       Return_parameters
0416 A9D9              *                       Exit ()                                 {return to the caller}
0417 A9D9              *                     END
0418 A9D9              *                   ELSE
0419 A9D9              *                     BEGIN
0420 A9D9              *                       Load_Seg(Seg_num)                       {load in the segment please}
0421 A9D9              *                       return_parameters
0422 A9D9              *                       Exit()                                  {return to the caller}
0423 A9D9              *                     END
0424 A9D9              *                 END
0425 A9D9              *               ELSE
0426 A9D9              *                 BEGIN                                         {segment not found}
0427 A9D9              *                   Return_error(Seg_Not_Found)
0428 A9D9              *                   Exit ()
0429 A9D9              *                 END
0430 A9D9              *               get_jmp_tbl_seg                                 {load any jump tables please}
0431 A9D9              *               Add_file_num                                    {Link this file in please}
0432 A9D9              *               Return_error(Seg_Not_Found)
0433 A9D9              *               Exit ()
0434 A9D9              *
0435 A9D9              ****************************************************************
0436 A9D9              *
0437 A9D9              LoadName PROC EXPORT
0438 A9D9                       LoadSegCheck 
0439 A9D9
0440 A9D9                       with DirectPage, Globals
0441 A9D9                       Import find_user_id,merge_path,compare_paths,find_seg_name, \
0442 A9D9                       open_load_file,load_segment,Process_Reloc,lock_segment, \ 
0443 A9D9                       setup_base_ptr,my_seg_to_user_seg 
0444 A9D9
0445 A9D9 A2 0A 00              ldx   #func_0D_param_cnt       ;get the number of parameters of the stack
0446 A9DC 20 C6 B9              jsr   get_parameters
0447 A9DF
0448 A9DF              ISegName EQU   input_parms
0449 A9DF              IFileName EQU   ISegName+4
0450 A9DF              IUserID  EQU   IFileName+4
0451 A9DF              OAddress EQU   1
0452 A9DF              OUserID  EQU   OAddress+4
0453 A9DF              OFileNum EQU   OUserID+2
0454 A9DF              OSegNum  EQU   OFileNum+2
0455 A9DF
0456 A9DF A5 E8                 lda   IUserID                  ;get the input user id
0457 A9E1 20 67 D4              jsr   find_user_id             ;see if we have the ID
0458 A9E4 90 03                 bcc   @its_mine
0459 A9E6 82 88 00              brl   old_loader               ;later we need to handle this better
0460 A9E9              @its_mine  
0461 A9E9              ;
0462 A9E9              ;At this point all errors that we encounter must be returned to the caller since the file is mine.
0463 A9E9              ;
0464 A9E9 A0 02 00              ldy   #ID_Table_Entry.ExpressHandle
0465 A9EC B7 62                 lda   [temp_ptr],y             ;get the ExpressLoad handle
0466 A9EE AA                    tax   
0467 A9EF C8                    iny   
0468 A9F0 C8                    iny   
0469 A9F1 B7 62                 lda   [temp_ptr],y
0470 A9F3 A8                    tay   
0471 A9F4 D0 09                 bne   @have_handle
0472 A9F6 8A                    txa   
0473 A9F7 D0 06                 bne   @have_handle             ;we have the handle
0474 A9F9 A9 F2 11              lda   #ExpressSegLost
0475 A9FC 38                    sec   
0476 A9FD 80 6F                 bra   @outta_here              ;report error to the caller.
0477 A9FF              @have_handle  
0478 A9FF 20 46 D3              jsr   merge_path               ;we now have the expanded ExpressLoad pathname
0479 AA02              ;
0480 AA02              ;At this point Expanded_name contains the Pathname from the ExpressLoad segment
0481 AA02              ;Now we need to build an Expanded Name from the Applications input pathname
0482 AA02              ;
0483 AA02 A4 E6                 ldy   IFileName+2              ;lets build the name
0484 AA04 A5 E4                 lda   IFileName
0485 AA06 A2 00 00              ldx   #0                       ;convert 0->1
0486 AA09 20 4E F7              jsr   Convert_Pathname         ;first, must convert from class 0 to class 1
0487 AA0C A5 18                 lda   TempBuff                 ;get pointer to converted name
0488 AA0E A4 1A                 ldy   TempBuff+2
0489 AA10 20 96 F7              jsr   Expand_Pathname          ;now do an ExpandPath on it
0490 AA13 B0 59                 bcs   @outta_here              ;GS/OS could not expand the pathname
0491 AA15
0492 AA15 20 D3 D2              jsr   compare_paths            ;see if the paths are equal
0493 AA18 A9 01 11              lda   #seg_not_found           ;pre-charge the error code if needed
0494 AA1B B0 51                 bcs   @outta_here              ;report error to the caller.
0495 AA1D A5 E2                 lda   ISegName+2               ;lets get a copy of the segment name
0496 AA1F A8                    tay   
0497 AA20 A5 E0                 lda   ISegName
0498 AA22 AA                    tax                            ;low word address of the segment name
0499 AA23 20 1D E3              jsr   find_seg_name            ;go and find the segment name in ExpressLoad
0500 AA26 B0 46                 bcs   @outta_here              ;report error to the caller.
0501 AA28 85 AC                 sta   search_seg               ;segment number of the segment
0502 AA2A
0503 AA2A A0 02 00              ldy   #HET_Entry.SegFlags      ;see if the segment is already loaded
0504 AA2D B7 42                 lda   [HET_entry_ptr],y
0505 AA2F 30 13                 bmi   @already_in              ;this segment is already loaded
0506 AA31              @do_load  
0507 AA31 20 69 DD              jsr   open_load_file           ;open the puppy
0508 AA34 B0 38                 bcs   @outta_here              ;report error to the caller.
0509 AA36 20 75 E1              jsr   load_segment             ;load the segment into memory
0510 AA39 B0 33                 bcs   @outta_here              ;report error to the caller.
0511 AA3B
0512 AA3B A5 AC                 lda   search_seg               ;relocate the segment
0513 AA3D 20 05 D6              jsr   Process_Reloc
0514 AA40 B0 2C                 bcs   @outta_here              ;report error to the caller.
0515 AA42 80 0D                 bra   @continue1
0516 AA44              @already_in  
0517 AA44 4A                    lsr   a                        ;see if the segment is purgable?
0518 AA45 90 07                 bcc   @continue
0519 AA47
0520 AA47 A5 AC                 lda   search_seg               ;go and lock the handle please
0521 AA49 20 06 E1              jsr   lock_segment
0522 AA4C B0 E3                 bcs   @do_load                 ;segment was purged behind my back!
0523 AA4E              @continue  
0524 AA4E 20 80 D2              jsr   setup_base_ptr           ;please setup the base pointer
0525 AA51              @continue1  
0526 AA51 A5 AC                 lda   search_seg               ;push the load segment number
0527 AA53 20 F4 D1              jsr   my_seg_to_user_seg       ;convert to user type number
0528 AA56 83 09                 sta   OSegNum,s
0529 AA58 A9 01 00              lda   #$0001                   ;file number
0530 AA5B 83 07                 sta   OFileNum,s
0531 AA5D AD B6 A6              lda   |USERID
0532 AA60 83 05                 sta   OUserID,s
0533 AA62 A5 9E                 lda   segment_entry+2          ;address of the segment
0534 AA64 83 03                 sta   OAddress+2,s
0535 AA66 A5 9C                 lda   segment_entry
0536 AA68 83 01                 sta   OAddress,s
0537 AA6A
0538 AA6A A9 00 00              lda   #$0000
0539 AA6D 18                    clc   
0540 AA6E              @outta_here  
0541 AA6E 4C 50 AB              jmp   cont7                    ;we were successful!!
0542 AA71
0543 AA71              old_loader  
0544 AA71              ;
0545 AA71              ;        initialize things
0546 AA71              ;
0547 AA71 64 07                 stz   OFileNum                 ;output File Num
0548 AA73 64 3A                 stz   Keep_Open                ;don't Keep File open
0549 AA75 64 38                 stz   Memory_Load              ;clear Memory Load flag
0550 AA77              ;
0551 AA77              ;        if UserID is 0, use USERID
0552 AA77              ;
0553 AA77 A5 E8                 lda   IUserID
0554 AA79 D0 03                 bne   cont1
0555 AA7B AD B6 A6              lda   |USERID
0556 AA7E 83 05        cont1    sta   OUserID,s
0557 AA80              ;
0558 AA80              ;       if UserID is an Application, don't close load file
0559 AA80              ;
0560 AA80 29 00 F0              and   #$F000
0561 AA83 C9 00 10              cmp   #Application
0562 AA86 D0 02                 bne   cont1a
0563 AA88 E6 3A                 inc   Keep_Open
0564 AA8A              ;
0565 AA8A              ;        convert type 0 pathname to type 1
0566 AA8A              ;
0567 AA8A A5 E4        cont1a   lda   IFileName
0568 AA8C A4 E6                 ldy   IFileName+2
0569 AA8E A2 00 00              ldx   #0
0570 AA91 20 4E F7              jsr   Convert_Pathname
0571 AA94 B0 38                 bcs   error_skip
0572 AA96              ;
0573 AA96              ;        expand input File Pathname
0574 AA96              ;
0575 AA96 A5 18                 lda   TempBuff
0576 AA98 A4 1A                 ldy   TempBuff+2
0577 AA9A 20 96 F7              jsr   Expand_Pathname
0578 AA9D B0 2F                 bcs   error_skip
0579 AA9F              ;
0580 AA9F              ;        search Pathname Table for input File Pathname
0581 AA9F              ;
0582 AA9F A3 05                 lda   OUserID,s                ;UserID
0583 AAA1 48                    pha   
0584 AAA2 F4 00 00              pea   #0                       ;File Number (none)
0585 AAA5 D4 1A                 pei   TempBuff+2               ;Address of full pathname
0586 AAA7 D4 18                 pei   TempBuff
0587 AAA9 20 7B F6              jsr   Find_Pathname
0588 AAAC B0 0B                 bcs   cont2
0589 AAAE              ;
0590 AAAE              ;        Input File Name is in Pathname Table, copy FileNum to output
0591 AAAE              ;
0592 AAAE BD 0A 00              lda   |PT_FileNum,x
0593 AAB1 83 07                 sta   OFileNum,s
0594 AAB3 4B                    phk                            ;restore DBR to PBR
0595 AAB4 AB                    plb   
0596 AAB5 64 14                 stz   Counter                  ;set to 0 as flag
0597 AAB7 80 05                 bra   cont3
0598 AAB9              ;
0599 AAB9              ;        input File Name is not in Pathname Table, move last File Number
0600 AAB9              ;        for the UserID in Pathname Table +1 to output.  Note: Counter contains
0601 AAB9              ;        the max File Num as an output from Find_Pathname subroutine
0602 AAB9              ;
0603 AAB9 A5 14        cont2    lda   Counter
0604 AABB 1A                    inc   a
0605 AABC 83 07                 sta   OFileNum,s
0606 AABE              ;
0607 AABE              ;        open file, if necessary
0608 AABE              ;
0609 AABE D4 1A        cont3    pei   TempBuff+2               ;address of file name
0610 AAC0 D4 18                 pei   TempBuff
0611 AAC2 A9 00 00              lda   #0
0612 AAC5 48                    pha                            ;no time/date stamp
0613 AAC6 48                    pha   
0614 AAC7 48                    pha   
0615 AAC8 48                    pha   
0616 AAC9 20 E4 F1              jsr   Open_File                ;open file
0617 AACC 90 03                 bcc   _1
0618 AACE              error_skip  
0619 AACE 4C 47 AB              jmp   Error_Exit
0620 AAD1              _1        
0621 AAD1              ;
0622 AAD1              ;        read next Segment Header
0623 AAD1              ;
0624 AAD1 C2 30        loop1    rep   #$30
0625 AAD3                       longa on
0626 AAD3                       longi on
0627 AAD3 20 26 EF              jsr   Next_Header
0628 AAD6 B0 F6                 bcs   error_skip
0629 AAD8              ;
0630 AAD8              ;        set TempZero to address of 1st char in SegName
0631 AAD8              ;
0632 AAD8 AD E0 A6     cont4    lda   Header.DispName          ;DISPNAME contains offset of SEGNAME in Header_Var
0633 AADB 18                    clc   
0634 AADC 6D 00 A7              adc   Header_Var
0635 AADF 85 00                 sta   TempZero
0636 AAE1 A9 00 00              lda   #0
0637 AAE4 6D 02 A7              adc   Header_Var+2
0638 AAE7 85 02                 sta   TempZero+2
0639 AAE9 AD C5 A6              lda   Header.LabLen            ;if LABLEN=0, both names are Pascal strings
0640 AAEC 29 FF 00              and   #$FF
0641 AAEF F0 08                 beq   cont4a
0642 AAF1 A5 00                 lda   TempZero                 ;if not, decrement pointer so indices line up
0643 AAF3 D0 02                 bne   @1
0644 AAF5 C6 02                 dec   TempZero+2
0645 AAF7              @1        
0646 AAF7 C6 00                 dec   TempZero
0647 AAF9              ;
0648 AAF9              ;        compare Segment Names
0649 AAF9              ;
0650 AAF9              cont4a    
0651 AAF9 E2 30                 sep   #$30
0652 AAFB                       longa off
0653 AAFB                       longi off
0654 AAFB A7 E0                 lda   [ISegName]               ;char count
0655 AAFD A8                    tay                            ;Y=index into each SegName
0656 AAFE B7 E0        loop2    lda   [ISegName],y
0657 AB00 D7 00                 cmp   [TempZero],y
0658 AB02 D0 CD                 bne   loop1                    ;char mismatch, try next Segment
0659 AB04 88                    dey   
0660 AB05 D0 F7                 bne   loop2
0661 AB07 C2 30                 rep   #$30
0662 AB09                       longa on
0663 AB09                       longi on
0664 AB09              ;
0665 AB09              ;        copy Segment Number from Segment Header to output
0666 AB09              ;
0667 AB09 AD DA A6              lda   Header.SegNum
0668 AB0C 83 09                 sta   OSegNum,s
0669 AB0E              ;
0670 AB0E              ;        add File Name to Pathname Table, if not already there
0671 AB0E              ;
0672 AB0E A5 14                 lda   Counter                  ;0 if already in table
0673 AB10 F0 26                 beq   cont6
0674 AB12 A3 05                 lda   OUserID,s                ;UserID
0675 AB14 48                    pha   
0676 AB15 A3 09                 lda   OFileNum+2,s             ;File Number
0677 AB17 48                    pha   
0678 AB18 AD 4A A7              lda   |POpen.modDateTime+6     ;mod_date/time
0679 AB1B 48                    pha   
0680 AB1C AD 48 A7              lda   |POpen.modDateTime+4
0681 AB1F 48                    pha   
0682 AB20 AD 46 A7              lda   |POpen.modDateTime+2
0683 AB23 48                    pha   
0684 AB24 AD 44 A7              lda   |POpen.modDateTime
0685 AB27 48                    pha   
0686 AB28 A9 00 00              lda   #0
0687 AB2B 48                    pha                            ;Direct Page/Stack info
0688 AB2C 48                    pha   
0689 AB2D 48                    pha                            ;Starting Address
0690 AB2E 48                    pha   
0691 AB2F D4 1A                 pei   TempBuff+2               ;Address of File Name
0692 AB31 D4 18                 pei   TempBuff
0693 AB33 20 B4 F5              jsr   Add_Pathname
0694 AB36 B0 0F                 bcs   Error_Exit
0695 AB38              ;
0696 AB38              ;           close file
0697 AB38              ;
0698 AB38 20 0E F3     cont6    jsr   Close_File
0699 AB3B              ;
0700 AB3B              ;        load segment found
0701 AB3B              ;
0702 AB3B              ; space for output address is already on stack
0703 AB3B              ;        pha                            ;output Address
0704 AB3B              ;        pha
0705 AB3B A3 05                 lda   OUserID,s                ;UserID
0706 AB3D 48                    pha   
0707 AB3E A3 09                 lda   OFileNum+2,s             ;File Number
0708 AB40 48                    pha   
0709 AB41 A3 0D                 lda   OSegNum+4,s              ;Segment Number
0710 AB43 48                    pha   
0711 AB44 20 2A E6              jsr   Load_Segment             ;Load Segment routine
0712 AB47
0713 AB47              Error_Exit  
0714 AB47              ;
0715 AB47              ;        if error occured, close file again
0716 AB47              ;
0717 AB47 90 07                 bcc   cont7
0718 AB49 48                    pha                            ;save status
0719 AB4A 64 3A                 stz   Keep_Open
0720 AB4C 20 0E F3              jsr   Close_File               ;close file
0721 AB4F 68                    pla                            ;restore status
0722 AB50
0723 AB50              cont7     
0724 AB50 48                    pha                            ;save status
0725 AB51 F4 08 70              pea   uTempBuff                ;dispose of temporary memory
0726 AB54 A2 02 11 22           _DisposeAll 
0727 AB5B 68                    pla                            ;restore status
0728 AB5C
0729 AB5C 4C 1B BA              jmp   return_to_caller
0730 AB5F
0731 AB5F                       ENDP 
0732 AB5F
0733 AB5F                       TITLE ', FUNCTIONS.a - ULoadSeg'
0734 AB5F              *
0735 AB5F              ****************************************************************
0736 AB5F              *
0737 AB5F              *              UnloadSeg ($0E)
0738 AB5F              *
0739 AB5F              *  Inputs:     Address in Segment (4 bytes)
0740 AB5F              *  Outputs:    UserID (2 bytes)
0741 AB5F              *              Load File Number (2 bytes)
0742 AB5F              *              Load Segment Number (2 bytes)
0743 AB5F              *  Errors:     $0000 - Operation successful
0744 AB5F              *              $1101 - Segment not found
0745 AB5F              *              $00xx - GS/OS I/O error
0746 AB5F              *              $02xx - Memory Manager error
0747 AB5F              *
0748 AB5F              ****************************************************************
0749 AB5F              *
0750 AB5F              ULoadSeg PROC EXPORT
0751 AB5F                       LoadSegCheck 
0752 AB5F
0753 AB5F                       with DirectPage, Globals
0754 AB5F                       Import find_seg_handle,make_purgable,my_seg_to_user_seg
0755 AB5F
0756 AB5F A2 04 00              ldx   #func_0E_param_cnt       ;get the number of parameters of the stack
0757 AB62 20 C6 B9              jsr   get_parameters
0758 AB65
0759 AB65              IAddress EQU   input_parms
0760 AB65              OUserID  EQU   1
0761 AB65              OFileNum EQU   OUserID+2
0762 AB65              OSegNum  EQU   OFileNum+2
0763 AB65
0764 AB65 64 AC                 stz   search_seg
0765 AB67              @retry    
0766 AB67 F4 00 00              pea   $0000
0767 AB6A F4 00 00              pea   $0000                    ;result space
0768 AB6D
0769 AB6D A5 E2                 lda   IAddress+2
0770 AB6F 85 A2                 sta   hold_long+2              ;save the address in case this is a jump table seg
0771 AB71 48                    pha                            ;address in a segment
0772 AB72 A5 E0                 lda   IAddress
0773 AB74 85 A0                 sta   hold_long
0774 AB76 48                    pha   
0775 AB77 A2 02 1A 22           _FindHandle 
0776 AB7E FA                    plx   
0777 AB7F 7A                    ply   
0778 AB80 B0 6D                 bcs   old_loader
0779 AB82 86 94                 stx   seg_handle               ;handle to the segment
0780 AB84 84 96                 sty   seg_handle+2
0781 AB86 20 3D D5              jsr   find_seg_handle
0782 AB89 B0 64                 bcs   old_loader               ;it must be in the original loader
0783 AB8B AA                    tax   
0784 AB8C
0785 AB8C A0 02 00              ldy   #HET_Entry.SegFlags      ;see if this is a jump segment
0786 AB8F B7 42                 lda   [HET_entry_ptr],y
0787 AB91 29 02 00              and   #jmp_type
0788 AB94 F0 3E                 beq   @not_jump
0789 AB96
0790 AB96 A5 A0                 lda   hold_long
0791 AB98 85 62                 sta   temp_ptr
0792 AB9A A5 A2                 lda   hold_long+2
0793 AB9C 85 64                 sta   temp_ptr+2               ;setup pointer to the segment entry please
0794 AB9E
0795 AB9E A7 62                 lda   [temp_ptr]               ;get the current opcode
0796 ABA0 29 FF 00              and   #$00FF                   ;clear the garbage
0797 ABA3 C9 22 00              cmp   #$0022                   ;is it a JSL instruction to ME???
0798 ABA6 D0 15                 bne   @chk_JML
0799 ABA8
0800 ABA8 38                    sec   
0801 ABA9 A5 62                 lda   temp_ptr                 ;make pointer to the load_seg_number field
0802 ABAB E9 06 00              sbc   #$0006
0803 ABAE 85 62                 sta   temp_ptr
0804 ABB0 A5 64                 lda   temp_ptr+2
0805 ABB2 E9 00 00              sbc   #$0000
0806 ABB5 85 64                 sta   temp_ptr+2               ;temp_ptr now points to the correct field
0807 ABB7
0808 ABB7              ;        User_ID                 2
0809 ABB7              ;        Load_File Number        2
0810 ABB7              ;        Load Segment Number     2
0811 ABB7              ;        Load Segment Offset     4
0812 ABB7              ;        JSL to Jump-table load  4
0813 ABB7
0814 ABB7 A7 62                 lda   [temp_ptr]               ;get the segment number please
0815 ABB9 85 AC                 sta   search_seg
0816 ABBB 80 18                 bra   @return_info
0817 ABBD
0818 ABBD              @chk_JML  
0819 ABBD C9 5C 00              cmp   #$005C                   ;is it a JML instruction!!
0820 ABC0 D0 2D                 bne   old_loader               ;let lou return the error
0821 ABC2              ;
0822 ABC2              ;Setup the new address to find
0823 ABC2              ;
0824 ABC2 A0 01 00              ldy   #$0001                   ;get the address that I need to unload please
0825 ABC5 B7 62                 lda   [temp_ptr],y
0826 ABC7 85 E0                 sta   IAddress
0827 ABC9 C8                    iny   
0828 ABCA C8                    iny   
0829 ABCB B7 62                 lda   [temp_ptr],y             ;get the high word please
0830 ABCD 29 FF 00              and   #$00FF                   ;clear garbage
0831 ABD0 85 E2                 sta   IAddress+2
0832 ABD2                                                      ;save the new address please
0833 ABD2 80 93                 bra   @retry
0834 ABD4              @not_jump  
0835 ABD4 8A                    txa                            ;setup the segment number
0836 ABD5
0837 ABD5              @return_info                            ;label moved so that we _always_ call Make_Purgeable
0838 ABD5 20 A5 DF              jsr   make_purgable            ;{gab - 04/23/90}
0839 ABD8
0840 ABD8 A5 AC                 lda   search_seg
0841 ABDA 20 F4 D1              jsr   my_seg_to_user_seg
0842 ABDD 83 05                 sta   OSegNum,s
0843 ABDF A9 01 00              lda   #$0001
0844 ABE2 83 03                 sta   OFileNum,s
0845 ABE4 AD B6 A6              lda   |USERID
0846 ABE7 83 01                 sta   OUserID,s
0847 ABE9 A9 00 00              lda   #$0000
0848 ABEC 4C 1B BA              jmp   return_to_caller         ;return to the caller
0849 ABEF
0850 ABEF              old_loader  
0851 ABEF              ;
0852 ABEF              ;        call Memory Manager with input Address
0853 ABEF              ;
0854 ABEF 48                    pha                            ;output Handle
0855 ABF0 48                    pha   
0856 ABF1 D4 E2                 pei   IAddress+2               ;Address
0857 ABF3 D4 E0                 pei   IAddress
0858 ABF5 A2 02 1A 22           _FindHandle 
0859 ABFC 68                    pla   
0860 ABFD 85 00                 sta   TempZero                 ;output Handle
0861 ABFF 68                    pla   
0862 AC00 85 02                 sta   TempZero+2
0863 AC02 05 00                 ora   TempZero                 ;if Handle=0, no find
0864 AC04 D0 06                 bne   cont1
0865 AC06 A9 01 11              lda   #NoFind
0866 AC09 4C 89 AC              jmp   Error_Exit
0867 AC0C              ;
0868 AC0C              ;        get UserID associated with Handle
0869 AC0C              ;
0870 AC0C A0 06 00     cont1    ldy   #6
0871 AC0F B7 00                 lda   [TempZero],y
0872 AC11 83 01                 sta   OUserID,s
0873 AC13              ;
0874 AC13              ;        search Memory Segment Table for entries having UserID
0875 AC13              ;
0876 AC13 AD AA A6              lda   |SEGTBL
0877 AC16 85 08                 sta   Handle
0878 AC18 AD AC A6              lda   |SEGTBL+2
0879 AC1B 85 0A                 sta   Handle+2
0880 AC1D 48           loop     pha                            ;output Handle
0881 AC1E 48                    pha   
0882 AC1F A3 05                 lda   OUserID+4,s              ;UserID
0883 AC21 48                    pha   
0884 AC22 A9 00 00              lda   #0
0885 AC25 48                    pha                            ;File Number
0886 AC26 48                    pha                            ;Segment Number
0887 AC27 20 7A F8              jsr   Next_MemSeg
0888 AC2A 68                    pla                            ;output Handle
0889 AC2B 68                    pla                            ;(not used)
0890 AC2C BD 0A 00              lda   |MS_Handle,x
0891 AC2F 85 04                 sta   TempZero+4               ;save Handle of Memory block
0892 AC31 BD 0C 00              lda   |MS_Handle+2,x
0893 AC34 85 06                 sta   TempZero+6
0894 AC36 A9 01 11              lda   #NoFind
0895 AC39 B0 4E                 bcs   Error_Exit               ;last entry scanned, no find
0896 AC3B              ;
0897 AC3B              ;        compare Handle of Memory block with Handle for input Address
0898 AC3B              ;
0899 AC3B A5 00                 lda   TempZero
0900 AC3D C5 04                 cmp   TempZero+4
0901 AC3F D0 DC                 bne   loop
0902 AC41 A5 02                 lda   TempZero+2
0903 AC43 C5 06                 cmp   TempZero+6
0904 AC45 D0 D6                 bne   loop
0905 AC47              ;
0906 AC47              ;        found Load Segment which contains the input address.  Check whether
0907 AC47              ;        segment is a Jump Table Segment
0908 AC47              ;
0909 AC47 BD 12 00              lda   |MS_Kind,x
0910 AC4A C9 02 00              cmp   #Jump_Segment
0911 AC4D D0 1C                 bne   cont2
0912 AC4F              ;
0913 AC4F              ;        segment is a Jump Table Segment.  Address points to JSL or JMP in
0914 AC4F              ;        one of the entries.  So extract the File Number and Segment Number
0915 AC4F              ;        from locations just above.
0916 AC4F              ;
0917 AC4F A5 E0                 lda   IAddress
0918 AC51 38                    sec   
0919 AC52 E9 08 00              sbc   #8
0920 AC55 85 00                 sta   TempZero
0921 AC57 A5 E2                 lda   IAddress+2
0922 AC59 E9 00 00              sbc   #0
0923 AC5C 85 02                 sta   TempZero+2
0924 AC5E A7 00                 lda   [TempZero]
0925 AC60 85 03                 sta   OFileNum                 ;File Number
0926 AC62 A0 02 00              ldy   #2
0927 AC65 B7 00                 lda   [TempZero],y
0928 AC67 85 05                 sta   OSegNum                  ;Segment Number
0929 AC69 80 0A                 bra   cont3
0930 AC6B              ;
0931 AC6B              ;        segment is a regular Load Segment.  Get File Number and Segment Number
0932 AC6B              ;        from Memory Segment Table entry.
0933 AC6B              ;
0934 AC6B BD 0E 00     cont2    lda   |MS_FileNum,x
0935 AC6E 83 03                 sta   OFileNum,s
0936 AC70 BD 10 00              lda   |MS_SegNum,x
0937 AC73 83 05                 sta   OSegNum,s
0938 AC75              ;
0939 AC75              ;        unload the specified segment
0940 AC75              ;
0941 AC75 4B           cont3    phk                            ;restore DBR
0942 AC76 AB                    plb   
0943 AC77 A3 01                 lda   OUserID,s                ;UserID
0944 AC79 48                    pha   
0945 AC7A A3 05                 lda   OFileNum+2,s             ;File Number
0946 AC7C 48                    pha   
0947 AC7D A3 09                 lda   OSegNum+4,s              ;Segment Number
0948 AC7F 48                    pha   
0949 AC80 F4 00 00              pea   $0000                    ;Dynamic Only Flag (false)
0950 AC83 F4 03 00              pea   $0003                    ;Purge Level
0951 AC86 20 E6 EA              jsr   Purge_Segment
0952 AC89
0953 AC89 4B           Error_Exit phk                          ;restore DBR
0954 AC8A AB                    plb   
0955 AC8B
0956 AC8B 4C 1B BA              jmp   return_to_caller
0957 AC8E
0958 AC8E                       ENDP 
0959 AC8E
0960 AC8E                       TITLE ', FUNCTIONS.a - GetInfo'
0961 AC8E              *
0962 AC8E              ****************************************************************
0963 AC8E              *
0964 AC8E              *              Get Segment Information ($0F)
0965 AC8E              *
0966 AC8E              *  Inputs:     UserID (2 bytes)
0967 AC8E              *              Load File Number (2 bytes)
0968 AC8E              *              Load Segment Number (2 bytes)
0969 AC8E              *              Address of User Buffer (4 bytes)
0970 AC8E              *  Outputs:    filled User Buffer
0971 AC8E              *  Errors:     $0000 - Operation successful
0972 AC8E              *              $1101 - Entry not found
0973 AC8E              *              $00xx - GS/OS I/O error
0974 AC8E              *              $02xx - Memory Manager error
0975 AC8E              *
0976 AC8E              ****************************************************************
0977 AC8E              *
0978 AC8E              GetInfo  PROC EXPORT
0979 AC8E                       LoadSegCheck 
0980 AC8E
0981 AC8E                       with DirectPage, Globals
0982 AC8E                       Import find_user_id,make_HET_ptr,seg_num_lookup,setup_seg_ptrs
0983 AC8E
0984 AC8E A2 0A 00              ldx   #func_0F_param_cnt       ;get the number of parameters of the stack
0985 AC91 20 C6 B9              jsr   get_parameters
0986 AC94
0987 AC94              IAddress EQU   input_parms
0988 AC94              ISegNum  EQU   IAddress+4
0989 AC94              IFileNum EQU   ISegNum+2
0990 AC94              IUserID  EQU   IFileNum+2
0991 AC94
0992 AC94 A5 E6                 lda   IFileNum
0993 AC96 3A                    dec   a
0994 AC97 D0 61                 bne   old_loader               ;if file number not 1 then call system loader
0995 AC99
0996 AC99 A5 E8                 lda   IUserID
0997 AC9B 20 67 D4              jsr   find_user_id             ;see if we have the ID
0998 AC9E B0 5A                 bcs   old_loader
0999 ACA0
1000 ACA0 A0 02 00              ldy   #ID_Table_Entry.ExpressHandle
1001 ACA3 B7 62                 lda   [temp_ptr],y             ;get the ExpressLoad handle
1002 ACA5 85 88                 sta   ExpressHandle
1003 ACA7 C8                    iny   
1004 ACA8 C8                    iny   
1005 ACA9 B7 62                 lda   [temp_ptr],y
1006 ACAB 85 8A                 sta   ExpressHandle+2
1007 ACAD 05 88                 ora   ExpressHandle
1008 ACAF D0 05                 bne   @have_handle
1009 ACB1 A9 F2 11              lda   #ExpressSegLost
1010 ACB4 80 41                 bra   @error_exit
1011 ACB6              @have_handle  
1012 ACB6 20 44 D2              jsr   make_HET_ptr             ;set up the HET pointer
1013 ACB9 A5 E4                 lda   ISegNum                  ;segment # to get info for
1014 ACBB 20 C8 D1              jsr   seg_num_lookup           ;convert the segment number to correct number
1015 ACBE B0 37                 bcs   @error_exit              ;the number is not valid
1016 ACC0 85 AC                 sta   search_seg
1017 ACC2 20 5E D2              jsr   setup_seg_ptrs           ;setup pointers for the transfer
1018 ACC5
1019 ACC5 A5 E8                 lda   IUserID                  ;copy UserID
1020 ACC7 87 E0                 sta   [IAddress]
1021 ACC9
1022 ACC9 A0 04 00              ldy   #HET_Entry.SegHandle     ;copy segment handle
1023 ACCC B7 42                 lda   [HET_entry_ptr],y
1024 ACCE 48                    pha   
1025 ACCF C8                    iny   
1026 ACD0 C8                    iny   
1027 ACD1 B7 42                 lda   [HET_entry_ptr],y
1028 ACD3 A0 04 00              ldy   #$0004
1029 ACD6 97 E0                 sta   [IAddress],y
1030 ACD8 88                    dey   
1031 ACD9 88                    dey   
1032 ACDA 68                    pla   
1033 ACDB 97 E0                 sta   [IAddress],y
1034 ACDD
1035 ACDD A0 06 00              ldy   #$0006                   ;copy load file #
1036 ACE0 A5 E6                 lda   IFileNum
1037 ACE2 97 E0                 sta   [IAddress],y
1038 ACE4
1039 ACE4 C8                    iny                            ;copy segment #
1040 ACE5 C8                    iny   
1041 ACE6 A5 E4                 lda   ISegNum
1042 ACE8 97 E0                 sta   [IAddress],y
1043 ACEA
1044 ACEA A0 18 00              ldy   #SegHeaderEntry.Kind     ;copy segment kind
1045 ACED B7 4E                 lda   [seg_header_ptr],y
1046 ACEF A0 0A 00              ldy   #10
1047 ACF2 97 E0                 sta   [IAddress],y
1048 ACF4
1049 ACF4 A9 00 00              lda   #0                       ;no error
1050 ACF7              @error_exit  
1051 ACF7 4C 1B BA              jmp   return_to_caller         ;report error to the caller.
1052 ACFA              old_loader  
1053 ACFA              ;
1054 ACFA              ;        search Memory Segment Table using inputs
1055 ACFA              ;
1056 ACFA 48                    pha                            ;output Handle
1057 ACFB 48                    pha   
1058 ACFC D4 E8                 pei   IUserID                  ;UserID
1059 ACFE D4 E6                 pei   IFileNum                 ;File Number
1060 AD00 D4 E4                 pei   ISegNum                  ;Segment Number
1061 AD02 20 6E F8              jsr   Find_MemSeg
1062 AD05 FA                    plx                            ;output Handle
1063 AD06 7A                    ply   
1064 AD07 4B                    phk                            ;restore DBR
1065 AD08 AB                    plb   
1066 AD09 B0 1E                 bcs   Error_Exit
1067 AD0B              ;
1068 AD0B              ;        dereference Handle
1069 AD0B              ;
1070 AD0B 8A                    txa   
1071 AD0C 20 D6 FA              jsr   DeRef
1072 AD0F              ;
1073 AD0F              ;        set Pointer to start of data
1074 AD0F              ; (returned from DeRef in Acc and Y)
1075 AD0F              ;
1076 AD0F 18                    clc   
1077 AD10 69 08 00              adc   #MS_UserID
1078 AD13 85 10                 sta   Pointer
1079 AD15 90 01                 bcc   @1
1080 AD17 C8                    iny   
1081 AD18              @1        
1082 AD18 84 12                 sty   Pointer+2
1083 AD1A              ;
1084 AD1A              ;        move data to user's buffer
1085 AD1A              ;
1086 AD1A 5A                    phy                            ;Source
1087 AD1B 48                    pha   
1088 AD1C D4 E2                 pei   IAddress+2               ;Destination
1089 AD1E D4 E0                 pei   IAddress
1090 AD20 F4 00 00              pea   $0000
1091 AD23 F4 0C 00              pea   MS_Kind-6                ;Count
1092 AD26 20 EE F9              jsr   Block_Move
1093 AD29
1094 AD29              Error_Exit  
1095 AD29 4C 1B BA              jmp   return_to_caller
1096 AD2C
1097 AD2C                       ENDP 
1098 AD2C
1099 AD2C                       TITLE ', FUNCTIONS.a - myGetUserID'
1100 AD2C              *
1101 AD2C              ****************************************************************
1102 AD2C              *
1103 AD2C              *              private Get UserID subroutine
1104 AD2C              *
1105 AD2C              *  Inputs:     Address of Pathname in a,y (class 1 string)
1106 AD2C              *  Outputs:    UserID (2 bytes)
1107 AD2C              *  Errors:     $0000 - Operation successful
1108 AD2C              *              $1101 - Entry not found
1109 AD2C              *              $00xx - GS/OS I/O error
1110 AD2C              *              $02xx - Memory Manager error
1111 AD2C              *
1112 AD2C              ****************************************************************
1113 AD2C              *
1114 AD2C              myGetUserID PROC 
1115 AD2C                       with DirectPage, Globals
1116 AD2C                       Import lock_handles,unlock_handles,path_to_user_id
1117 AD2C
1118 AD2C              OUserID  EQU   3
1119 AD2C
1120 AD2C 20 96 F7              jsr   Expand_Pathname          ;make it a full pathname
1121 AD2F 20 D7 D4              jsr   path_to_user_id          ;given a path this routine finds a user ID
1122 AD32 90 11                 bcc   Normal_Exit              ;go store the user_id
1123 AD34
1124 AD34              old_loader  
1125 AD34              ;
1126 AD34              ;        search Pathname Table for full pathname
1127 AD34              ;
1128 AD34 A9 00 00              lda   #0
1129 AD37 48                    pha                            ;UserID (none)
1130 AD38 48                    pha                            ;File Number (none)
1131 AD39 D4 1A                 pei   TempBuff+2               ;Address of Pathname
1132 AD3B D4 18                 pei   TempBuff
1133 AD3D 20 7B F6              jsr   Find_Pathname
1134 AD40 B0 08                 bcs   Error_Exit
1135 AD42
1136 AD42 BD 08 00              lda   |PT_UserID,x
1137 AD45              Normal_Exit  
1138 AD45 83 03                 sta   OUserID,s
1139 AD47
1140 AD47 A9 00 00              lda   #0                       ;clear Accumulator (no error)
1141 AD4A
1142 AD4A 4B           Error_Exit phk   
1143 AD4B AB                    plb                            ;restore DBR
1144 AD4C
1145 AD4C 48                    pha                            ;save status
1146 AD4D F4 08 70              pea   uTempBuff                ;dispose of temporary memory
1147 AD50 A2 02 11 22           _DisposeAll 
1148 AD57 68                    pla                            ;restore status
1149 AD58
1150 AD58 60                    rts   
1151 AD59
1152 AD59                       EndP 
1153 AD59
1154 AD59                       TITLE ', FUNCTIONS.a - GetUserID'
1155 AD59              *
1156 AD59              ****************************************************************
1157 AD59              *
1158 AD59              *              Get UserID ($10)
1159 AD59              *
1160 AD59              *  Inputs:     Address of Pathname (4 bytes)
1161 AD59              *  Outputs:    UserID (2 bytes)
1162 AD59              *  Errors:     $0000 - Operation successful
1163 AD59              *              $1101 - Entry not found
1164 AD59              *              $00xx - GS/OS I/O error
1165 AD59              *              $02xx - Memory Manager error
1166 AD59              *
1167 AD59              ****************************************************************
1168 AD59              *
1169 AD59              GetUserID PROC EXPORT
1170 AD59                       LoadSegCheck 
1171 AD59
1172 AD59                       with DirectPage
1173 AD59
1174 AD59 A2 04 00              ldx   #func_10_param_cnt       ;get the number of parameters of the stack
1175 AD5C 20 C6 B9              jsr   get_parameters
1176 AD5F
1177 AD5F              IAddress EQU   input_parms
1178 AD5F              OUserID  EQU   1
1179 AD5F
1180 AD5F              ;
1181 AD5F              ;        convert type 0 pathname to type 1
1182 AD5F              ;
1183 AD5F A5 E0                 lda   IAddress
1184 AD61 A4 E2                 ldy   IAddress+2
1185 AD63 A2 00 00              ldx   #0
1186 AD66 20 4E F7              jsr   Convert_Pathname
1187 AD69 B0 07                 bcs   Error_Exit
1188 AD6B              ;
1189 AD6B              ;       then call the _real_ GetUserID routine
1190 AD6B              ;
1191 AD6B A4 1A                 ldy   TempBuff+2               ;converted pathname
1192 AD6D A5 18                 lda   TempBuff
1193 AD6F 20 2C AD              jsr   myGetUserID              ;go find the User ID
1194 AD72
1195 AD72              Error_Exit  
1196 AD72 4C 1B BA              jmp   return_to_caller
1197 AD75
1198 AD75
1199 AD75                       ENDP 
1200 AD75
1201 AD75                       TITLE ', FUNCTIONS.a - GetUserID 2'
1202 AD75              *
1203 AD75              ****************************************************************
1204 AD75              *
1205 AD75              *              Get UserID 2 ($21) - Type 1 Pathname used
1206 AD75              *
1207 AD75              *  Inputs:     Address of Pathname (4 bytes)
1208 AD75              *  Outputs:    UserID (2 bytes)
1209 AD75              *  Errors:     $0000 - Operation successful
1210 AD75              *              $1101 - Entry not found
1211 AD75              *              $00xx - GS/OS I/O error
1212 AD75              *              $02xx - Memory Manager error
1213 AD75              *
1214 AD75              ****************************************************************
1215 AD75              *
1216 AD75              GetUserID2 PROC EXPORT
1217 AD75                       LoadSegCheck 
1218 AD75
1219 AD75                       with DirectPage
1220 AD75
1221 AD75 A2 04 00              ldx   #func_21_param_cnt       ;get the number of parameters of the stack
1222 AD78 20 C6 B9              jsr   get_parameters
1223 AD7B
1224 AD7B              IAddress EQU   input_parms
1225 AD7B
1226 AD7B A5 E0                 lda   IAddress                 ;get the name pointer into registers
1227 AD7D A4 E2                 ldy   IAddress+2
1228 AD7F
1229 AD7F 20 2C AD              jsr   myGetUserID              ;call the _real_ workhorse
1230 AD82
1231 AD82 4C 1B BA              jmp   return_to_caller
1232 AD85
1233 AD85                       ENDP 
1234 AD85
1235 AD85                       TITLE ', FUNCTIONS.a - GetPathname'
1236 AD85              *
1237 AD85              ****************************************************************
1238 AD85              *
1239 AD85              *              Get Pathname ($11)
1240 AD85              *
1241 AD85              *  Inputs:     UserID (2 bytes)
1242 AD85              *              File Number (2 bytes)
1243 AD85              *  Outputs:    Address of Pathname (4 bytes)
1244 AD85              *  Errors:     $0000 - Operation successful
1245 AD85              *              $1101 - Entry not found
1246 AD85              *              $00xx - GS/OS I/O error
1247 AD85              *              $02xx - Memory Manager error
1248 AD85              *
1249 AD85              ****************************************************************
1250 AD85              *
1251 AD85              GetPathname PROC EXPORT
1252 AD85                       LoadSegCheck 
1253 AD85
1254 AD85                       with DirectPage, Globals
1255 AD85                       Import find_user_id,merge_path, GString_to_PString
1256 AD85
1257 AD85 A2 04 00              ldx   #func_11_param_cnt       ;get the number of parameters of the stack
1258 AD88 20 C6 B9              jsr   get_parameters
1259 AD8B
1260 AD8B              IFileNum EQU   input_parms
1261 AD8B              IUserID  EQU   IFileNum+2
1262 AD8B              OAddress EQU   1
1263 AD8B
1264 AD8B F4 08 70              pea   uTempBuff                ;dispose of any old buffer
1265 AD8E A2 02 11 22           _DisposeAll 
1266 AD95
1267 AD95 A5 E0                 lda   IFileNum
1268 AD97 3A                    dec   a
1269 AD98 D0 48                 bne   old_loader               ;if file number not 1 then call system loader
1270 AD9A
1271 AD9A A5 E2                 lda   IUserID
1272 AD9C 20 67 D4              jsr   find_user_id             ;see if we have the ID
1273 AD9F B0 41                 bcs   old_loader
1274 ADA1
1275 ADA1 A0 02 00              ldy   #ID_Table_Entry.ExpressHandle
1276 ADA4 B7 62                 lda   [temp_ptr],y             ;get the ExpressLoad handle
1277 ADA6 AA                    tax   
1278 ADA7 C8                    iny   
1279 ADA8 C8                    iny   
1280 ADA9 B7 62                 lda   [temp_ptr],y
1281 ADAB A8                    tay   
1282 ADAC D0 09                 bne   @have_handle
1283 ADAE 8A                    txa   
1284 ADAF D0 06                 bne   @have_handle             ;we have the handle
1285 ADB1 A9 F2 11              lda   #ExpressSegLost
1286 ADB4 38                    sec   
1287 ADB5 80 27                 bra   @error_exit              ;report error to the caller.
1288 ADB7              @have_handle  
1289 ADB7 20 46 D3              jsr   merge_path               ;Build a GString
1290 ADBA
1291 ADBA D4 8A                 pei   ExpressHandle+2
1292 ADBC D4 88                 pei   ExpressHandle
1293 ADBE A2 02 20 22           _HLock                         ;we better lock it down for a bit
1294 ADC5
1295 ADC5 A5 CE                 lda   PathnamePtr
1296 ADC7 A4 D0                 ldy   PathnamePtr+2
1297 ADC9 A2 01 00              ldx   #1
1298 ADCC 20 4E F7              jsr   Convert_Pathname         ;convert to a class 0 string
1299 ADCF 48                    pha                            ;save return status
1300 ADD0
1301 ADD0 D4 8A                 pei   ExpressHandle+2          ;now we can unlock the handle
1302 ADD2 D4 88                 pei   ExpressHandle
1303 ADD4 A2 02 22 22           _HUnlock 
1304 ADDB
1305 ADDB 68                    pla   
1306 ADDC 80 29                 bra   store_pointer
1307 ADDE
1308 ADDE              @error_exit  
1309 ADDE A6 E2                 ldx   IUserID
1310 ADE0 D0 31                 bne   outta_here
1311 ADE2
1312 ADE2              old_loader  
1313 ADE2              ;
1314 ADE2              ;        search Pathname Table for UserID
1315 ADE2              ;
1316 ADE2 D4 E2                 pei   IUserID                  ;UserID
1317 ADE4 D4 E0                 pei   IFileNum                 ;File Number
1318 ADE6 A9 00 00              lda   #0
1319 ADE9 48                    pha                            ;Address of Pathname
1320 ADEA 48                    pha   
1321 ADEB 20 7B F6              jsr   Find_Pathname
1322 ADEE B0 21                 bcs   Error_Exit
1323 ADF0
1324 ADF0 8A                    txa   
1325 ADF1 18                    clc   
1326 ADF2 69 1E 00              adc   #PT_Path
1327 ADF5 AA                    tax                            ;save in X for a minute
1328 ADF6 8B                    phb   
1329 ADF7 8B                    phb   
1330 ADF8 68                    pla   
1331 ADF9 29 FF 00              and   #$FF
1332 ADFC 90 01                 bcc   @1
1333 ADFE 1A                    inc   a
1334 ADFF              @1        
1335 ADFF A8                    tay                            ;put high word in Y
1336 AE00 8A                    txa                            ;retrieve low word
1337 AE01              ;
1338 AE01              ;        convert pathname to type 0
1339 AE01              ;
1340 AE01 A2 01 00              ldx   #1
1341 AE04 20 4E F7              jsr   Convert_Pathname
1342 AE07              store_pointer  
1343 AE07 AA                    tax                            ;save status
1344 AE08 A5 18                 lda   TempBuff
1345 AE0A 83 01                 sta   OAddress,s
1346 AE0C A5 1A                 lda   TempBuff+2
1347 AE0E 83 03                 sta   OAddress+2,s
1348 AE10 8A                    txa   
1349 AE11              Error_Exit  
1350 AE11 4B                    phk   
1351 AE12 AB                    plb                            ;restore DBR
1352 AE13              outta_here  
1353 AE13 4C 1B BA              jmp   return_to_caller
1354 AE16
1355 AE16                       ENDP 
1356 AE16
1357 AE16                       TITLE ', FUNCTIONS.a - GetPathname 2'
1358 AE16              *
1359 AE16              ****************************************************************
1360 AE16              *
1361 AE16              *              Get Pathname 2 ($22) - Type 1 Pathname used
1362 AE16              *
1363 AE16              *  Inputs:     UserID (2 bytes)
1364 AE16              *              File Number (2 bytes)
1365 AE16              *  Outputs:    Address of Pathname (4 bytes)
1366 AE16              *  Errors:     $0000 - Operation successful
1367 AE16              *              $1101 - Entry not found
1368 AE16              *              $00xx - GS/OS I/O error
1369 AE16              *              $02xx - Memory Manager error
1370 AE16              *
1371 AE16              ****************************************************************
1372 AE16              *
1373 AE16              GetPathname2 PROC Export
1374 AE16                       LoadSegCheck 
1375 AE16
1376 AE16                       with DirectPage, Globals
1377 AE16                       Import merge_path,find_user_id,MemMove,do_alloc
1378 AE16
1379 AE16 A2 04 00              ldx   #func_22_param_cnt       ;get the number of parameters of the stack
1380 AE19 20 C6 B9              jsr   get_parameters
1381 AE1C
1382 AE1C              IFileNum EQU   input_parms
1383 AE1C              IUserID  EQU   IFileNum+2
1384 AE1C              OAddress EQU   1
1385 AE1C
1386 AE1C F4 08 77              pea   uLGetPathname            ;dispose of any old buffer
1387 AE1F A2 02 11 22           _DisposeAll 
1388 AE26
1389 AE26 A5 E0                 lda   IFileNum
1390 AE28 3A                    dec   a
1391 AE29 D0 22                 bne   old_loader               ;if file number not 1 then call system loader
1392 AE2B
1393 AE2B A5 E2                 lda   IUserID
1394 AE2D 20 67 D4              jsr   find_user_id             ;see if we have the ID
1395 AE30 B0 1B                 bcs   old_loader
1396 AE32
1397 AE32 A0 02 00              ldy   #ID_Table_Entry.ExpressHandle
1398 AE35 B7 62                 lda   [temp_ptr],y             ;get the ExpressLoad handle
1399 AE37 AA                    tax   
1400 AE38 C8                    iny   
1401 AE39 C8                    iny   
1402 AE3A B7 62                 lda   [temp_ptr],y
1403 AE3C A8                    tay   
1404 AE3D D0 09                 bne   @have_handle
1405 AE3F 8A                    txa   
1406 AE40 D0 06                 bne   @have_handle             ;we have the handle
1407 AE42 A9 F2 11              lda   #ExpressSegLost
1408 AE45 38                    sec   
1409 AE46 80 52                 bra   Error_Exit               ;report error to the caller.
1410 AE48
1411 AE48              @have_handle  
1412 AE48 20 46 D3              jsr   merge_path
1413 AE4B 80 22                 bra   copy_pathname            ;go copy the pathname into a temp buffer
1414 AE4D
1415 AE4D              old_loader  
1416 AE4D              ;
1417 AE4D              ;        search Pathname Table for UserID
1418 AE4D              ;
1419 AE4D D4 E2                 pei   IUserID                  ;UserID
1420 AE4F D4 E0                 pei   IFileNum                 ;File Number
1421 AE51 A9 00 00              lda   #0
1422 AE54 48                    pha                            ;Address of Pathname
1423 AE55 48                    pha   
1424 AE56 20 7B F6              jsr   Find_Pathname
1425 AE59 B0 3F                 bcs   Error_Exit
1426 AE5B
1427 AE5B 8A                    txa   
1428 AE5C 18                    clc   
1429 AE5D 69 1E 00              adc   #PT_Path
1430 AE60 85 CE                 sta   PathnamePtr
1431 AE62 8B                    phb   
1432 AE63 8B                    phb   
1433 AE64 68                    pla   
1434 AE65 29 FF 00              and   #$FF
1435 AE68 90 01                 bcc   @1                       ;was there a carry from the above calculation?
1436 AE6A 1A                    inc   a                        ;yes, adjust bank #
1437 AE6B              @1        
1438 AE6B 85 D0                 sta   PathnamePtr+2
1439 AE6D 4B                    phk   
1440 AE6E AB                    plb   
1441 AE6F              copy_pathname  
1442 AE6F A7 CE                 lda   [PathnamePtr]            ;get the length of the pathname
1443 AE71 1A                    inc   a                        ;adjust for leading length word
1444 AE72 1A                    inc   a
1445 AE73 AA                    tax                            ;pass in X register
1446 AE74 A0 00 00              ldy   #0                       ;always < 64K
1447 AE77 A9 08 77              lda   #uLGetPathname           ;use this ID to allocate memory
1448 AE7A 20 52 D0              jsr   do_alloc                 ;allocate some memory
1449 AE7D B0 1B                 bcs   Error_Exit               ;oops!  couldn't get the memory
1450 AE7F
1451 AE7F 8A                    txa                            ;put low word of handle into Accumulator
1452 AE80 20 D6 FA              jsr   DeRef                    ;deref the handle (into Acc & Y)
1453 AE83
1454 AE83 AA                    tax                            ;save low word in X for a second
1455 AE84 83 01                 sta   OAddress,s               ;store return pointer
1456 AE86 98                    tya   
1457 AE87 83 03                 sta   OAddress+2,s
1458 AE89
1459 AE89 D4 D0                 pei   PathnamePtr+2            ;source for move
1460 AE8B D4 CE                 pei   PathnamePtr
1461 AE8D 5A                    phy                            ;destination pointer
1462 AE8E DA                    phx   
1463 AE8F A7 CE                 lda   [PathnamePtr]            ;get length
1464 AE91 1A                    inc   a                        ;include length word
1465 AE92 1A                    inc   a
1466 AE93 48                    pha   
1467 AE94 20 7A FA              jsr   MemMove                  ;copy the string
1468 AE97
1469 AE97 A9 00 00              lda   #0                       ;signify no error
1470 AE9A              Error_Exit  
1471 AE9A 4B                    phk   
1472 AE9B AB                    plb                            ;restore DBR
1473 AE9C
1474 AE9C              outta_here  
1475 AE9C 4C 1B BA              jmp   return_to_caller
1476 AE9F
1477 AE9F                       ENDP 
1478 AE9F
1479 AE9F                       TITLE ', FUNCTIONS.a - myUserShutdown'
1480 AE9F              *
1481 AE9F              ****************************************************************
1482 AE9F              *
1483 AE9F              *              private User Shutdown function
1484 AE9F              *
1485 AE9F              *  Inputs:     UserID (2 bytes)
1486 AE9F              *              Quit Flag (2 bytes)
1487 AE9F              *
1488 AE9F              *  Outputs:    UserID (2 bytes)
1489 AE9F              *
1490 AE9F              *  Errors:     $0000 - Operation successful
1491 AE9F              *              $00xx - GS/OS I/O error
1492 AE9F              *              $02xx - Memory Manager error
1493 AE9F              *
1494 AE9F              ****************************************************************
1495 AE9F              *
1496 AE9F              myUserShutdown Proc 
1497 AE9F                       with DirectPage, Globals
1498 AE9F
1499 AE9F              IQuit    EQU   input_parms
1500 AE9F              IUserID  EQU   IQuit+2
1501 AE9F              OUserID  EQU   3                        ;allow for extra return address
1502 AE9F
1503 AE9F A5 E2                 lda   IUserID
1504 AEA1 D0 03                 bne   cont1
1505 AEA3 AD B6 A6              lda   |USERID
1506 AEA6 83 03        cont1    sta   OUserID,s
1507 AEA8              ;
1508 AEA8              ;       close all the Files associated with this UserID
1509 AEA8              ;
1510 AEA8 64 38                 stz   Memory_Load
1511 AEAA 64 3A                 stz   Keep_Open
1512 AEAC              ;
1513 AEAC              ;       get the first Pathname Table entry for this UserID
1514 AEAC              ;
1515 AEAC 48                    pha                            ;UserID
1516 AEAD A9 00 00              lda   #0
1517 AEB0 48                    pha                            ;File Number (any)
1518 AEB1 48                    pha                            ;Pathname (none)
1519 AEB2 48                    pha   
1520 AEB3 20 7B F6              jsr   Find_Pathname
1521 AEB6 90 11                 bcc   cont2
1522 AEB8 4C 77 AF              jmp   Error_Exit
1523 AEBB              ;
1524 AEBB              ;       get next Pathname entry for this UserID
1525 AEBB              ;
1526 AEBB A3 03        loop     lda   OUserID,s                ;UserID
1527 AEBD 48                    pha   
1528 AEBE A9 00 00              lda   #0
1529 AEC1 48                    pha                            ;File Number (any)
1530 AEC2 48                    pha                            ;Pathname (none)
1531 AEC3 48                    pha   
1532 AEC4 20 87 F6              jsr   Next_Pathname
1533 AEC7 B0 35                 bcs   eloop
1534 AEC9              ;
1535 AEC9              ;       get Pathname and save for Open_File
1536 AEC9              ;
1537 AEC9 8A           cont2    txa   
1538 AECA 18                    clc   
1539 AECB 69 1E 00              adc   #PT_Path
1540 AECE 85 00                 sta   TempZero
1541 AED0 8B                    phb   
1542 AED1 8B                    phb   
1543 AED2 68                    pla   
1544 AED3 29 FF 00              and   #$FF
1545 AED6 90 01                 bcc   @1                       ;propage carry for possible
1546 AED8 1A                    inc   a                        ;bank crossing
1547 AED9              @1        
1548 AED9 85 02                 sta   TempZero+2
1549 AEDB              ;
1550 AEDB              ;       bump handle of Pathname Table entry to next
1551 AEDB              ;
1552 AEDB BD 00 00              lda   |MS_Next,x
1553 AEDE 85 08                 sta   Handle
1554 AEE0 BD 02 00              lda   |MS_Next+2,x
1555 AEE3 85 0A                 sta   Handle+2
1556 AEE5              ;
1557 AEE5              ;       restore DBR
1558 AEE5              ;
1559 AEE5 4B                    phk   
1560 AEE6 AB                    plb   
1561 AEE7              ;
1562 AEE7              ;       open (only gets refnum) and close Load File
1563 AEE7              ;
1564 AEE7 A7 00                 lda   [TempZero]               ;get the length of the pathname
1565 AEE9 F0 D0                 beq   loop                     ;if 0, just skip the OS calls
1566 AEEB
1567 AEEB D4 02                 pei   TempZero+2               ;Pathname
1568 AEED D4 00                 pei   TempZero
1569 AEEF A9 00 00              lda   #0                       ;Time/Date stamp
1570 AEF2 48                    pha   
1571 AEF3 48                    pha   
1572 AEF4 48                    pha   
1573 AEF5 48                    pha   
1574 AEF6 20 E4 F1              jsr   Open_File
1575 AEF9 20 0E F3              jsr   Close_File
1576 AEFC 80 BD                 bra   loop
1577 AEFE
1578 AEFE 4B           eloop    phk   
1579 AEFF AB                    plb   
1580 AF00              ;
1581 AF00              ;        if Quit Flag=
1582 AF00              ;
1583 AF00              ;        $0000 - cleanup internal tables and dispose all memory
1584 AF00              ;        $8000 - reloadable - same as above except spare Pathname Table
1585 AF00              ;        other - restartable
1586 AF00              ;
1587 AF00 A6 E0                 ldx   IQuit
1588 AF02 F0 05                 beq   cont3
1589 AF04 E0 00 80              cpx   #$8000
1590 AF07 D0 41                 bne   cont5
1591 AF09              ;
1592 AF09              ;        cleanup internal tables for UserID
1593 AF09              ;
1594 AF09 A3 03        cont3    lda   OUserID,s                ;UserID
1595 AF0B 48                    pha                            ;once for _DisposeAll
1596 AF0C 48                    pha   
1597 AF0D 20 A0 F9              jsr   Cleanup
1598 AF10              ;
1599 AF10              ;        dispose of all memory blocks for UserID
1600 AF10              ;
1601 AF10 A2 02 11 22           _DisposeAll 
1602 AF17              ;
1603 AF17              ;        if Quit Flag<>$8000, remove UserID from Pathname Table and delete it
1604 AF17              ;
1605 AF17 A6 E0                 ldx   IQuit
1606 AF19 E0 00 80              cpx   #$8000
1607 AF1C F0 14                 beq   cont4
1608 AF1E
1609 AF1E A3 03                 lda   OUserID,s
1610 AF20 48                    pha                            ;extra for Remove_UserID
1611 AF21 48                    pha   
1612 AF22 A2 03 21 22           _DeleteID 
1613 AF29
1614 AF29 F4 01 00              pea   PATHTBL>>16
1615 AF2C F4 B2 A6              pea   |PATHTBL
1616 AF2F 20 C8 F8              jsr   Remove_UserID
1617 AF32              ;
1618 AF32              ;        remove UserID from Jump Table and Memory Segment Table
1619 AF32              ;
1620 AF32 A3 03        cont4    lda   OUserID,s
1621 AF34 48                    pha                            ;extra for Remove_UserID
1622 AF35 48                    pha   
1623 AF36 F4 01 00              pea   JMPTBL>>16
1624 AF39 F4 AE A6              pea   |JMPTBL
1625 AF3C 20 C8 F8              jsr   Remove_UserID
1626 AF3F
1627 AF3F F4 01 00              pea   SEGTBL>>16
1628 AF42 F4 AA A6              pea   |SEGTBL
1629 AF45 20 C8 F8              jsr   Remove_UserID
1630 AF48
1631 AF48 80 2A                 bra   OK_Exit
1632 AF4A              ;
1633 AF4A              ;        User is Restartable, purge all dynamic segments for this UserID
1634 AF4A              ;        from all tables (this will also dispose of memory block handles)
1635 AF4A              ;
1636 AF4A              cont5     
1637 AF4A F4 03 00              pea   3                        ;purge level for _SetPurgeAll
1638 AF4D A3 05                 lda   OUserID+2,s              ;UserID
1639 AF4F 48                    pha                            ;for _SetPurgeAll
1640 AF50 48                    pha                            ;for _PurgeAll
1641 AF51 48                    pha                            ;for _HUnlockAll
1642 AF52 48                    pha                            ;for Purge_Segment
1643 AF53 A9 00 00              lda   #0
1644 AF56 48                    pha                            ;all Load Files
1645 AF57 48                    pha                            ;all Load Segments
1646 AF58 F4 01 00              pea   1                        ;Dynamic Segments only
1647 AF5B 48                    pha                            ;Purge Level (dispose)
1648 AF5C 20 E6 EA              jsr   Purge_Segment
1649 AF5F              ;
1650 AF5F              ;        unlock all load segments
1651 AF5F              ;
1652 AF5F A2 02 23 22           _HUnlockAll 
1653 AF66              ;
1654 AF66              ;        purge all other dynamic segments
1655 AF66              ;
1656 AF66 A2 02 13 22           _PurgeAll 
1657 AF6D              ;
1658 AF6D              ;        make all static segments purgeable
1659 AF6D              ;
1660 AF6D A2 02 25 22           _SetPurgeAll 
1661 AF74
1662 AF74 A9 00 00     OK_Exit  lda   #0
1663 AF77 60           Error_Exit rts                          ;back to caller
1664 AF78
1665 AF78                       EndP 
1666 AF78
1667 AF78                       TITLE ', FUNCTIONS.a - UserShutdown'
1668 AF78              *
1669 AF78              ****************************************************************
1670 AF78              *
1671 AF78              *              User Shutdown ($12)
1672 AF78              *
1673 AF78              *  Inputs:     UserID (2 bytes)
1674 AF78              *              Quit Flag (2 bytes)
1675 AF78              *
1676 AF78              *  Outputs:    UserID (2 bytes)
1677 AF78              *
1678 AF78              *  Errors:     $0000 - Operation successful
1679 AF78              *              $00xx - GS/OS I/O error
1680 AF78              *              $02xx - Memory Manager error
1681 AF78              *
1682 AF78              ****************************************************************
1683 AF78              *
1684 AF78              UserShutdown PROC EXPORT
1685 AF78                       LoadSegCheck 
1686 AF78
1687 AF78                       with DirectPage, Globals
1688 AF78                       Import find_user_id,close_dynamic_file,remove_segment
1689 AF78                       Import mark_all_purgable,delete_user_id
1690 AF78
1691 AF78 A2 04 00              ldx   #func_12_param_cnt       ;get the number of parameters of the stack
1692 AF7B 20 C6 B9              jsr   get_parameters
1693 AF7E
1694 AF7E              IQuit    EQU   input_parms
1695 AF7E              IUserID  EQU   IQuit+2
1696 AF7E              OUserID  EQU   1
1697 AF7E
1698 AF7E A5 E2                 lda   IUserID                  ;see if this is my User ID
1699 AF80 20 67 D4              jsr   find_user_id             ;Is this mine?
1700 AF83 90 03                 bcc   @found_it                ;yes...
1701 AF85 82 7D 00              brl   old_loader               ;no. It must belong to the system loader
1702 AF88              @found_it  
1703 AF88 A0 02 00              ldy   #ID_Table_Entry.ExpressHandle
1704 AF8B B7 62                 lda   [temp_ptr],y             ;get the ExpressLoad handle
1705 AF8D AA                    tax   
1706 AF8E C8                    iny   
1707 AF8F C8                    iny   
1708 AF90 B7 62                 lda   [temp_ptr],y
1709 AF92 A8                    tay   
1710 AF93 D0 09                 bne   @have_handle
1711 AF95 8A                    txa   
1712 AF96 D0 06                 bne   @have_handle             ;we have the handle
1713 AF98 A9 F2 11              lda   #ExpressSegLost
1714 AF9B 38                    sec   
1715 AF9C 80 63                 bra   @error_exit              ;report error to the caller.
1716 AF9E              @have_handle  
1717 AF9E 86 88                 stx   ExpressHandle
1718 AFA0 84 8A                 sty   ExpressHandle+2
1719 AFA2 20 C5 DC              jsr   close_dynamic_file       ;close file if any segments were dynamic
1720 AFA5
1721 AFA5 A5 62                 lda   temp_ptr                 ;setup the User_ID pointer to point to the entry
1722 AFA7 85 7C                 sta   user_id_ptr
1723 AFA9 A5 64                 lda   temp_ptr+2
1724 AFAB 85 7E                 sta   user_id_ptr+2
1725 AFAD
1726 AFAD A5 E0                 lda   IQuit                    ;save the guit flag
1727 AFAF                                                      ;what type of kill is this?
1728 AFAF F0 1E                 beq   @nuke_it                 ;remove the entire application
1729 AFB1 C9 00 80              cmp   #$8000                   ;is this a "keep Only Table" quit
1730 AFB4 D0 0B                 bne   @make_dormant            ;this a restart attemp
1731 AFB6              ;
1732 AFB6              ;If we get here we need to purge the app but keep our tables intack
1733 AFB6              ;
1734 AFB6 A9 00 00              lda   #purge_all               ;remove all segments
1735 AFB9 A2 00 00              ldx   #$0000                   ;LOAD flags AND mask COMPARE value BEQ REMOVE_IT
1736 AFBC 20 17 D4              jsr   remove_segment           ;deallocate the segments
1737 AFBF 80 35                 bra   @norm_exit
1738 AFC1
1739 AFC1              @make_dormant  
1740 AFC1 A9 04 00              lda   #purge_dynamics          ;remove dynamic segments
1741 AFC4 A2 00 00              ldx   #$0000                   ;LOAD flags AND mask COMPARE value BEQ REMOVE_IT
1742 AFC7 20 17 D4              jsr   remove_segment           ;deallocate the segments
1743 AFCA 20 1B E0              jsr   mark_all_purgable
1744 AFCD 80 27                 bra   @norm_exit
1745 AFCF              @nuke_it  
1746 AFCF 48                    pha                            ;space for handle
1747 AFD0 48                    pha   
1748 AFD1 D4 7E                 pei   user_id_ptr+2            ;lock down the user ID table
1749 AFD3 D4 7C                 pei   user_id_ptr
1750 AFD5 A2 02 1A 22           _FindHandle 
1751 AFDC A3 03                 lda   3,s                      ;duplicate the handle on the stack
1752 AFDE 48                    pha   
1753 AFDF A3 03                 lda   3,s
1754 AFE1 48                    pha   
1755 AFE2 A2 02 20 22           _HLock 
1756 AFE9
1757 AFE9 A9 00 00              lda   #nuke_id                 ;delete the ID and the memory
1758 AFEC 20 BE D3              jsr   delete_user_id           ;remove the user_id please
1759 AFEF
1760 AFEF A2 02 22 22           _HUnlock                       ;unlock the user ID table
1761 AFF6
1762 AFF6              @norm_exit  
1763 AFF6 AD B6 A6              lda   |USERID
1764 AFF9 83 01                 sta   OUserID,s
1765 AFFB A9 00 00              lda   #$0000
1766 AFFE              @outta_here  
1767 AFFE 4C 1B BA              jmp   return_to_caller         ;we were successful!!
1768 B001              @error_exit  
1769 B001 A6 E2                 ldx   IUserID
1770 B003 D0 F9                 bne   @outta_here
1771 B005
1772 B005              old_loader  
1773 B005 20 9F AE              jsr   myUserShutdown           ;call private function
1774 B008
1775 B008 4C 1B BA              jmp   return_to_caller
1776 B00B
1777 B00B                       ENDP 
1778 B00B
1779 B00B                       TITLE ', FUNCTIONS.a - RenamePathname'
1780 B00B              *
1781 B00B              ****************************************************************
1782 B00B              *
1783 B00B              *              Rename Pathname ($13)
1784 B00B              *
1785 B00B              *  Inputs:     Address of old Pathname (4 bytes) - Type 1 pathname
1786 B00B              *              Address of new Pathname (4 bytes) - Type 1 pathname
1787 B00B              *  Outputs:    none
1788 B00B              *  Errors:     $0000 - Operation successful
1789 B00B              *              $02xx - Memory Manager error
1790 B00B              *
1791 B00B              ****************************************************************
1792 B00B              *
1793 B00B              RenamePathname PROC EXPORT
1794 B00B                       LoadSegCheck 
1795 B00B
1796 B00B                       with DirectPage, Globals
1797 B00B                       Import rename_segments, compare_paths, adjust_handle_size, change_pathname
1798 B00B
1799 B00B A2 08 00              ldx   #func_13_param_cnt       ;get the number of parameters of the stack
1800 B00E 20 C6 B9              jsr   get_parameters
1801 B011
1802 B011              newAddr  EQU   input_parms
1803 B011              oldAddr  EQU   newAddr+4
1804 B011
1805 B011              ;
1806 B011              ;       indicate to compare_paths that a partial match is OK
1807 B011              ;
1808 B011 A9 00 80              lda   #$8000
1809 B014 85 A4                 sta   partial_match            ;indicate that a partial match is OK
1810 B016
1811 B016              ;
1812 B016              ;           if either input pathname is NIL, just exit with no error
1813 B016              ;
1814 B016 A5 E4                 lda   oldAddr
1815 B018 05 E6                 ora   oldAddr+2
1816 B01A D0 03                 bne   cont1
1817 B01C              its_null  
1818 B01C 4C DF B0              jmp   OK_Exit
1819 B01F A5 E0        cont1    lda   newAddr
1820 B021 05 E2                 ora   newAddr+2
1821 B023 F0 F7                 beq   its_null
1822 B025 A7 E4        cont2    lda   [oldAddr]
1823 B027 F0 F3                 beq   its_null
1824 B029 A7 E0        cont3    lda   [newAddr]
1825 B02B F0 EF                 beq   its_null
1826 B02D
1827 B02D              ;
1828 B02D              ;           expand both input pathnames (to upper case them)
1829 B02D              ;
1830 B02D A5 E4        cont3a   lda   oldAddr
1831 B02F A4 E6                 ldy   oldAddr+2
1832 B031 20 96 F7              jsr   Expand_Pathname
1833 B034 90 03                 bcc   _1
1834 B036              error_skip  
1835 B036 4C E2 B0              jmp   Error_Exit
1836 B039              _1        
1837 B039 A5 18                 lda   TempBuff
1838 B03B 85 E4                 sta   oldAddr
1839 B03D A5 1A                 lda   TempBuff+2
1840 B03F 85 E6                 sta   oldAddr+2
1841 B041
1842 B041 A5 E0                 lda   newAddr
1843 B043 A4 E2                 ldy   newAddr+2
1844 B045 20 96 F7              jsr   Expand_Pathname
1845 B048 B0 EC                 bcs   error_skip
1846 B04A A5 18                 lda   TempBuff
1847 B04C 85 E0                 sta   newAddr
1848 B04E A5 1A                 lda   TempBuff+2
1849 B050 85 E2                 sta   newAddr+2
1850 B052              ;
1851 B052              ;           if input and output pathnames are the same, exit
1852 B052              ;
1853 B052 A7 E4                 lda   [oldAddr]
1854 B054 C7 E0                 cmp   [newAddr]
1855 B056 D0 16                 bne   do_rename                ;different lengths, just do the rename
1856 B058
1857 B058 A8           cont3b   tay   
1858 B059 C8                    iny   
1859 B05A E2 20                 sep   #$20
1860 B05C                       longa off
1861 B05C B7 E4        loop0    lda   [oldAddr],y
1862 B05E 57 E0                 eor   [newAddr],y              ;case insensentive comparision
1863 B060 29 DF                 and   #$DF                     ;ignore the case bit
1864 B062 D0 08                 bne   cont3c
1865 B064 88                    dey   
1866 B065 D0 F5                 bne   loop0
1867 B067 C2 20                 rep   #$20
1868 B069                       longa on
1869 B069              to_OK_Exit  
1870 B069 4C DF B0              jmp   OK_Exit                  ;they're the same!
1871 B06C              cont3c    
1872 B06C C2 20                 rep   #$20
1873 B06E                       longa on
1874 B06E              do_rename  
1875 B06E A5 E4                 lda   oldAddr                  ;point TempBuff to old pathname
1876 B070 85 18                 sta   TempBuff
1877 B072 A5 E6                 lda   oldAddr+2
1878 B074 85 1A                 sta   TempBuff+2
1879 B076
1880 B076 20 03 E5              jsr   rename_segments          ;go and rename ExpressLoad stuff
1881 B079
1882 B079              old_loader  
1883 B079              ;
1884 B079              ;           oldAddr = points into old input pathname
1885 B079              ;           newAddr = points into new input pathname
1886 B079              ;           oldTable = points into original Pathname Table entry
1887 B079              ;           newTable = points into new      Pathname Table entry
1888 B079
1889 B079              ;
1890 B079              ;           search Pathname Table for a match to old Pathname (match only the number of chars
1891 B079              ;           corresponding to the length of the old Pathname)
1892 B079              ;
1893 B079 AD B4 A6              lda   |PATHTBL+2
1894 B07C 85 0A                 sta   Handle+2
1895 B07E AD B2 A6              lda   |PATHTBL
1896 B081 85 08                 sta   Handle                   ;handle to 1st entry
1897 B083 05 0A                 ora   Handle+2
1898 B085 F0 58                 beq   OK_Exit                  ;yes, end of pathname table
1899 B087              loop1     
1900 B087 A5 08                 lda   Handle
1901 B089 A4 0A                 ldy   Handle+2
1902 B08B 20 D6 FA              jsr   DeRef                    ;dereference Handle
1903 B08E              ;
1904 B08E              ;           bump returned pointer to start of pathname in Pathname Table entry
1905 B08E              ;
1906 B08E 18                    clc   
1907 B08F 69 1E 00              adc   #PT_Path
1908 B092 85 CE                 sta   PathnamePtr              ;set PathnamePtr to name within Pathname table entry
1909 B094 90 01                 bcc   @1
1910 B096 C8                    iny   
1911 B097              @1        
1912 B097 84 D0                 sty   PathnamePtr+2
1913 B099
1914 B099 A7 CE                 lda   [PathnamePtr]            ;check for a NULL pathname (memory-loaded file)
1915 B09B F0 28                 beq   eloop1                   ;if NULL, there's no way there's gonna be a match
1916 B09D
1917 B09D 20 D3 D2              jsr   compare_paths            ;compare the pathnames
1918 B0A0 B0 23                 bcs   eloop1                   ;no match
1919 B0A2
1920 B0A2 08                    php                            ;save partial/full match status
1921 B0A3 A7 E0                 lda   [newAddr]                ;get the length of the new name
1922 B0A5 38                    sec   
1923 B0A6 E7 E4                 sbc   [oldAddr]                ;calculate difference (may be negative)
1924 B0A8 F0 17                 beq   @no_size_change          ;if same length, no adjustment necessary
1925 B0AA 20 EE E5              jsr   adjust_handle_size       ;change the size of the table entry
1926 B0AD B0 16                 bcs   eloop1                   ;just punt if we get an error
1927 B0AF A0 02 00              ldy   #2                       ;deref Handle
1928 B0B2 A7 08                 lda   [Handle]
1929 B0B4 18                    clc   
1930 B0B5 69 1E 00              adc   #PT_Path                 ;offset to position of pathname within segment
1931 B0B8 85 CE                 sta   PathnamePtr
1932 B0BA B7 08                 lda   [Handle],y
1933 B0BC 69 00 00              adc   #0
1934 B0BF 85 D0                 sta   PathnamePtr+2
1935 B0C1              @no_size_change  
1936 B0C1 28                    plp                            ;retrieve complete/partial match status
1937 B0C2 20 A0 E5              jsr   change_pathname          ;go make the change
1938 B0C5              ;
1939 B0C5              ;           continue to next entry
1940 B0C5              ;
1941 B0C5 A5 08        eloop1   lda   Handle
1942 B0C7 A4 0A                 ldy   Handle+2
1943 B0C9 20 D6 FA              jsr   DeRef
1944 B0CC 85 10                 sta   Pointer
1945 B0CE 84 12                 sty   Pointer+2
1946 B0D0 A0 02 00              ldy   #PT_Next+2               ;bump Handle to Next Handle
1947 B0D3 B7 10                 lda   [Pointer],y
1948 B0D5 85 0A                 sta   Handle+2
1949 B0D7 A7 10                 lda   [Pointer]
1950 B0D9 85 08                 sta   Handle
1951 B0DB 05 0A                 ora   Handle+2
1952 B0DD D0 A8                 bne   loop1                    ;continue checking
1953 B0DF
1954 B0DF A9 00 00     OK_Exit  lda   #0
1955 B0E2              Error_Exit  
1956 B0E2 48                    pha                            ;save status
1957 B0E3 F4 08 70              pea   uTempBuff                ;dispose of temporary memory
1958 B0E6 A2 02 11 22           _DisposeAll 
1959 B0ED 68                    pla                            ;restore status
1960 B0EE 4C 1B BA              jmp   return_to_caller
1961 B0F1
1962 B0F1                       ENDP 
1963 B0F1
1964 B0F1                       TITLE ', FUNCTIONS.a - GetGlobalsAddr'
1965 B0F1              *
1966 B0F1              ****************************************************************
1967 B0F1              *
1968 B0F1              *              GetGlobalsAddr ($1E)
1969 B0F1              *
1970 B0F1              *  Inputs:     none
1971 B0F1              *
1972 B0F1              *  Outputs:    Globals address (4 bytes)
1973 B0F1              *
1974 B0F1              *  Errors:     $0000 - Operation successful
1975 B0F1              *
1976 B0F1              ****************************************************************
1977 B0F1              *
1978 B0F1              GetGlobalsAddr PROC EXPORT
1979 B0F1                       LoadSegCheck 
1980 B0F1
1981 B0F1                       with DirectPage, Globals
1982 B0F1
1983 B0F1              oAddress equ   7
1984 B0F1
1985 B0F1 A9 8C A6              lda   #Globals
1986 B0F4 83 07                 sta   oAddress,s
1987 B0F6 A9 01 00              lda   #^Globals
1988 B0F9 83 09                 sta   oAddress+2,s
1989 B0FB A9 00 00              lda   #0
1990 B0FE 18                    clc   
1991 B0FF 6B                    rtl   
1992 B100                       EndP 
